-- MySQL dump 8.23
--
-- Host: localhost    Database: gamestatus
---------------------------------------------------------
-- Server version	3.23.58

--
-- Table structure for table `Developer`
--

CREATE TABLE Developer (
  DeveloperSeq int(10) unsigned NOT NULL auto_increment,
  Name varchar(80) NOT NULL default '',
  Website varchar(255) default NULL,
  PRIMARY KEY  (DeveloperSeq),
  UNIQUE KEY UC_DeveloperSeq (DeveloperSeq),
  UNIQUE KEY UC_Name (Name)
) TYPE=MyISAM;

--
-- Dumping data for table `Developer`
--


INSERT INTO Developer (DeveloperSeq, Name, Website) VALUES (20,'Bungie','http://www.bungie.com');
INSERT INTO Developer (DeveloperSeq, Name, Website) VALUES (15,'Sierra','http://www.sierraonline.com');
INSERT INTO Developer (DeveloperSeq, Name, Website) VALUES (21,'Id Software','http://www.idsoftware.com/');
INSERT INTO Developer (DeveloperSeq, Name, Website) VALUES (22,'Blizzard','http://www.blizzard.com');

--
-- Table structure for table `Game`
--

CREATE TABLE Game (
  GameSeq int(10) unsigned NOT NULL auto_increment,
  Title varchar(80) default NULL,
  GenreSeq int(10) unsigned default NULL,
  PublisherSeq int(10) unsigned default NULL,
  DeveloperSeq int(10) unsigned default NULL,
  StatusCode char(1) default NULL,
  Website varchar(255) default NULL,
  Description text,
  Review text,
  PRIMARY KEY  (GameSeq),
  UNIQUE KEY UC_GameSeq (GameSeq)
) TYPE=MyISAM;

--
-- Dumping data for table `Game`
--


INSERT INTO Game (GameSeq, Title, GenreSeq, PublisherSeq, DeveloperSeq, StatusCode, Website, Description, Review) VALUES (1,'Doom',3,5,21,'R','http://www.doom.com','Ground breaking FPS','One of the all time classics.');
INSERT INTO Game (GameSeq, Title, GenreSeq, PublisherSeq, DeveloperSeq, StatusCode, Website, Description, Review) VALUES (11,'Halo',3,2,20,'R','','','');
INSERT INTO Game (GameSeq, Title, GenreSeq, PublisherSeq, DeveloperSeq, StatusCode, Website, Description, Review) VALUES (12,'Halo 2',3,2,20,'R','','Succeeds.','');
INSERT INTO Game (GameSeq, Title, GenreSeq, PublisherSeq, DeveloperSeq, StatusCode, Website, Description, Review) VALUES (10,'Doom 4',3,5,21,'A','','Why?','');
INSERT INTO Game (GameSeq, Title, GenreSeq, PublisherSeq, DeveloperSeq, StatusCode, Website, Description, Review) VALUES (5,'Doom 3',3,5,21,'S','http://www.doom3.com','Follow up to Doom','4 Stars.');
INSERT INTO Game (GameSeq, Title, GenreSeq, PublisherSeq, DeveloperSeq, StatusCode, Website, Description, Review) VALUES (9,'Doom 3',3,5,21,'R','http://www.doom3.com','Another Great ID engine','Scary.');
INSERT INTO Game (GameSeq, Title, GenreSeq, PublisherSeq, DeveloperSeq, StatusCode, Website, Description, Review) VALUES (7,'HaHa',1,4,15,'S','http://www.yahoo.com','Great O\'hello','Howdeeeees');
INSERT INTO Game (GameSeq, Title, GenreSeq, PublisherSeq, DeveloperSeq, StatusCode, Website, Description, Review) VALUES (8,'World of Warcraft',2,9,22,'R','http://worldofwarcraft.blizzard.com/','MMORPG','Usual Blizzard craftsmanship.  Enjoyable if not ground breaking.');

--
-- Table structure for table `GamePlatform`
--

CREATE TABLE GamePlatform (
  GameSeq int(10) unsigned NOT NULL default '0',
  PlatformSeq int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (GameSeq,PlatformSeq)
) TYPE=MyISAM;

--
-- Dumping data for table `GamePlatform`
--


INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (1,1);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (5,3);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (7,2);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (8,1);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (9,1);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (9,2);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (9,3);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (9,5);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (10,1);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (11,1);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (11,2);
INSERT INTO GamePlatform (GameSeq, PlatformSeq) VALUES (12,2);

--
-- Table structure for table `Genre`
--

CREATE TABLE Genre (
  GenreSeq int(10) unsigned NOT NULL auto_increment,
  Name varchar(40) NOT NULL default '',
  PRIMARY KEY  (GenreSeq),
  UNIQUE KEY UC_GenreSeq (GenreSeq),
  UNIQUE KEY UC_Name (Name)
) TYPE=MyISAM;

--
-- Dumping data for table `Genre`
--


INSERT INTO Genre (GenreSeq, Name) VALUES (1,'Action/Adventure');
INSERT INTO Genre (GenreSeq, Name) VALUES (2,'Role Playing');
INSERT INTO Genre (GenreSeq, Name) VALUES (3,'FPS');
INSERT INTO Genre (GenreSeq, Name) VALUES (4,'Strategy');
INSERT INTO Genre (GenreSeq, Name) VALUES (5,'Sports');
INSERT INTO Genre (GenreSeq, Name) VALUES (6,'Simulation');
INSERT INTO Genre (GenreSeq, Name) VALUES (7,'Edutainment');

--
-- Table structure for table `Platform`
--

CREATE TABLE Platform (
  PlatformSeq int(10) unsigned NOT NULL auto_increment,
  Name varchar(40) NOT NULL default '',
  PlatformIcon varchar(255) default NULL,
  PRIMARY KEY  (PlatformSeq),
  UNIQUE KEY UC_PlatformSeq (PlatformSeq),
  UNIQUE KEY UC_Name (Name)
) TYPE=MyISAM;

--
-- Dumping data for table `Platform`
--


INSERT INTO Platform (PlatformSeq, Name, PlatformIcon) VALUES (1,'PC',NULL);
INSERT INTO Platform (PlatformSeq, Name, PlatformIcon) VALUES (2,'XBox',NULL);
INSERT INTO Platform (PlatformSeq, Name, PlatformIcon) VALUES (3,'PS/2',NULL);
INSERT INTO Platform (PlatformSeq, Name, PlatformIcon) VALUES (4,'Gamecube',NULL);
INSERT INTO Platform (PlatformSeq, Name, PlatformIcon) VALUES (5,'Mac',NULL);

--
-- Table structure for table `Publisher`
--

CREATE TABLE Publisher (
  PublisherSeq int(10) unsigned NOT NULL auto_increment,
  Name varchar(80) default NULL,
  PRIMARY KEY  (PublisherSeq),
  UNIQUE KEY UC_PublisherSeq (PublisherSeq),
  UNIQUE KEY UC_Name (Name)
) TYPE=MyISAM;

--
-- Dumping data for table `Publisher`
--


INSERT INTO Publisher (PublisherSeq, Name) VALUES (2,'Microsoft');
INSERT INTO Publisher (PublisherSeq, Name) VALUES (3,'Electronic Arts');
INSERT INTO Publisher (PublisherSeq, Name) VALUES (4,'Infogram');
INSERT INTO Publisher (PublisherSeq, Name) VALUES (5,'Activision');
INSERT INTO Publisher (PublisherSeq, Name) VALUES (6,'Atari');
INSERT INTO Publisher (PublisherSeq, Name) VALUES (7,'Ubisoft');
INSERT INTO Publisher (PublisherSeq, Name) VALUES (8,'Acclaim');
INSERT INTO Publisher (PublisherSeq, Name) VALUES (9,'Vivendi Universal Interactive');

--
-- Table structure for table `Status`
--

CREATE TABLE Status (
  StatusCode char(1) NOT NULL default '',
  Description varchar(40) default NULL,
  PRIMARY KEY  (StatusCode),
  UNIQUE KEY UC_StatusCode (StatusCode)
) TYPE=MyISAM;

--
-- Dumping data for table `Status`
--


INSERT INTO Status (StatusCode, Description) VALUES ('A','Announced');
INSERT INTO Status (StatusCode, Description) VALUES ('B','Beta');
INSERT INTO Status (StatusCode, Description) VALUES ('D','Development');
INSERT INTO Status (StatusCode, Description) VALUES ('P','Alpha');
INSERT INTO Status (StatusCode, Description) VALUES ('O','Open Beta');
INSERT INTO Status (StatusCode, Description) VALUES ('R','Released');

