<?php
/************************************************************************/
/* PHP-NUKE: Web Portal System                                          */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2001 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
// Daoc_servers (English Version)										//
// David Rolston														//
// Based on the work of msw/greycouncil.org								//
//																		//
// PHP-Nuke 5.4 Compatible												//
/************************************************************************/
// Place This file in your NUKE blocks directory
// Use the Admin Blocks Menu and create a custom block
//
// From the File drop down menu select DAoC News.  Activate it and your block should
// appear.
// If you have questions you can leave me a message on the General Protectorites Forum 
/************************************************************************/
// DAoC Server Status v1.0, msw, 12/2001
// Simple script to print out a very basic server status page using the xml
// from Camelot Herald. Check out http://www.camelotherald.com/xml.php
//
// I use this code in a 'block' on my php-Nuke website (http://home.greycouncil.org/)
// and it works fine. Should work as a simple webpage for others that have
// php/xml support.
//
// Hope this helps ya out, I won't support ya, don't ask me questions!
// I myself spent about a hour or so reading the tutorials the Mythic guys
// listed on their website. If you can't figure this out or have problems visit there.
// 
// Tutorial for XML/PHP http://www.webmasterbase.com/article/560
//
// To see the plain version hit http://home.greycouncil.org/test-xml/daoc-servers.php
//
// To see the php-Nuke BLOCK version hit http://home.greycouncil.org/
//
// This ain't by any means the best way to do this I am sure but it works.
//
// Run this like you would any other php script on your website.... that is
// all...See ya in game (well, when they fix/add a few things!)
// -------------------------------------------------------------------------------------
// Modifications to add master function, better error handling,
// and RealmURL links by David Rolston (gizmo@gizmola.com)
// 1/1/2002
// Samples ->  
// http://www.tribecali.com/
// http://www.protectorites.com/
// 

if (eregi("block-DAoC_Servers.php",$PHP_SELF)) {
    Header("Location: index.php");
    die();
}

$insideitem = false;
$tag = "";
$da_server = "";
$da_population = "";
$da_type ="";
$da_status = "";
$da_totalpop=0;

$da_boxcontent="";

function startElement($parser, $tagName, $attrs) {    
global $insideitem, $tag, $da_server, $da_type;
	
	if ($insideitem) {
		$tag = $tagName;
	} elseif ($tagName == "SERVER") {	
		$insideitem = true;    
		while (list ($key, $val) = each ($attrs)) {
			switch($key) {
				case "NAME": 
					$da_server=$val;
					break;
				case "TYPE": 
					$da_type=$val;
					break;
			} // end case
		} // end while
	}
}

function characterData($parser, $data) {    
global $insideitem, $tag, $da_server, $da_population, $da_type, $da_status,$da_totalpop;
	if ($insideitem) {
		switch ($tag) {            
			case "POPULATION":	
				$da_population .= $data; 
				$da_totalpop += $data; 
				break;            
			case "STATUS":		
				$da_status .= $data; 
				break;
		}    
	}
}

function endElement($parser, $tagName) {    
	global $insideitem, $tag, $da_server, $da_population, $da_type, $da_status, $da_realmurl, $da_boxcontent;
	
	if ($tagName == "SERVER") {
		$da_boxcontent .= "<TR><TD><font size=2><A HREF=http://www.camelotherald.com/realms/";
		$da_boxcontent .= "$da_server><b>$da_server</b></A>";
		if ($da_type) { 
			$da_boxcontent .= "(<i>$da_type</i>)"; 
		}
		$da_boxcontent .= "</font></TD>";
		$da_boxcontent .= "<TD align=center><font size=2>$da_status</font></TD>";
		$da_boxcontent .= "<TD align=right><font size=2>$da_population</font></TD></TR>\n";

		$da_server = "";        
		$da_population = "";        
		$da_status = "";
		$da_type = "";
		$insideitem = false;    
	}
}

// gotta have this for the php-NUKE block stuff to work
// returns a string with the Status Info (DHR)
function make_daoc() {
global $da_totalpop, $da_boxcontent;
$da_realmurl="http://www.camelotherald.com/realms/";

// Create an XML parser
$xml_parser = xml_parser_create();

// Set the functions to handle opening and closing tags
xml_set_element_handler($xml_parser, "startElement", "endElement");

// Set the function to handle blocks of character data
xml_set_character_data_handler($xml_parser, "characterData");

// print "<hr>\n";
$da_boxcontent .= "<TABLE BORDER=0 WIDTH=0%>\n<TR>\n";
// Open the XML file for reading
$fp = @fopen("http://www.camelotherald.com/xml/servers.xml","r");
if ($fp) {  
	$da_boxcontent .= "<TD><font size=2><B>Server</B></font></TD><TD><font size=2><B>Status</B></font></TD><TD><font size=2><B>Users</B></font></TD>\n";
	$da_boxcontent .= "</TR>\n";
	
	// Read the XML file 4KB at a time
	while ($data = fread($fp, 4096)) {   
		// Parse each 4KB chunk with the XML parser created above
		if (!(xml_parse($xml_parser, $data, feof($fp)))) {
			$da_boxcontent .= "XML error:";
			$da_boxcontent .= xml_error_string(xml_get_error_code($xml_parser));
			$da_boxcontent .= "at line ";
			$da_boxcontent .= xml_get_current_line_number($xml_parser);
			break;
		}
	}
	// Close the XML file
	fclose($fp);
	$da_boxcontent .= "<TR><TD><font size=2>Total Users</font></TD><TD></TD><TD align=right><font size=2>$da_totalpop</font></TD></TR>\n";	
} else {
	$da_boxcontent .= "<TD>Unavailable</TD></TR>\n";	
}
$da_boxcontent .= "</TABLE>\n";
// Free up memory used by the XML parser
xml_parser_free($xml_parser);
return $da_boxcontent;
}

$content .= make_daoc();
?>